using System;
using EnvDTE;
using Microsoft.VisualBasic;

namespace ToolboxSnippetsInstaller
{
	/// <summary>
	/// Summary description for ToolboxInstaller.
	/// </summary>
	public class ToolboxInstaller
	{
		public ToolboxInstaller()
		{
			//
			// TODO: Add constructor logic here
			//
		}
		
		/// <summary>
		/// Metoda aduje dowoln liczb fragmentw kodu do okienka narzdziowego
		/// </summary>
		public static void LoadSnippets()
		{
			// Zarejestrowanie filtra komunikatw OLE, by unikn wyjtkw "call rejected"
			MessageFilter.Register();
			
			// Pobranie odwoania do obiektu DTE
			Type latestDTE = Type.GetTypeFromProgID("VisualStudio.DTE.7.1");
			EnvDTE.DTE env = Activator.CreateInstance(latestDTE) as EnvDTE.DTE;
			
			// Pobranie okna narzdziowego Toolbox
			Window win = env.Windows.Item(Constants.vsWindowKindToolbox);
			
			// Pobranie okna narzdziowego
			ToolBox toolBox = (ToolBox) win.Object;

			ToolBoxTab tab = null;
			
			// Przejcie przez kolekcj zakadek i sprawdzenie, czy odpowiednia zakadka ju istnieje
			foreach (ToolBoxTab tb in toolBox.ToolBoxTabs)
			{
				if (tb.Name == "Nasze kontrolki")
				{
					tab = tb;
				}
			}

			// Zakadka nie istnieje, wic trzeba j doda
			if(tab == null)
			{
				tab = toolBox.ToolBoxTabs.Add("Nasze kontrolki");
			}
			
			// Wywietlenie okna waciwoci, by ustrzec si bdw
			env.ExecuteCommand("View.PropertiesWindow","");		
			
			// Uaktywnienie zakadki (poniewa metoda Add dodaje kontrolki tylko do aktywnej zakadki)		
			tab.Activate();
			
			// Wybranie pierwszej pozycji (jest to jedyny sposb, by wszystko poszo dobrze)
			tab.ToolBoxItems.Item(1).Select();
			
			// Dodanie do okna narzdziowego nowych pozycji - wasnych kontrolek
			ToolBoxItem tbi1 = tab.ToolBoxItems.Add("not used", @"C:\windows\Microsoft.NET\Framework\v1.1.4322\System.Web.dll", vsToolBoxItemFormat.vsToolBoxItemFormatDotNETComponent);
			
			// Zamknicie rodowiska
			env.Quit();
			// Odczenie filtra komunikatw
			MessageFilter.Revoke();

		}
	}
}
